(function(){

    "use strict"; 

    var stripe_pub_key = $('#stripe_pub_key').val();
    Stripe.setPublishableKey(stripe_pub_key);
     
    //callback to handle the response from stripe
    function stripeResponseHandler(status, response) {
        if (response.error) {
            $('#payBtn').removeAttr("disabled");
            $(".payment-errors").html('<div class="alert alert-danger">'+response.error.message+'</div>');
        } else {
            var form$ = $("#paymentFrm");
            var token = response['id'];
            form$.append("<input type='hidden' name='stripeToken' value='" + token + "' />");
            form$.get(0).submit();
        }
    }

    $("#paymentFrm").submit(function(event) {

        //disable the submit button to prevent repeated clicks
        $('#payBtn').attr("disabled", "disabled");
        
        //create single-use token to charge the user
        Stripe.createToken({
            number: $('.card-number').val(),
            cvc: $('.card-cvc').val(),
            exp_month: $('.card-expiry-month').val(),
            exp_year: $('.card-expiry-year').val()
        }, stripeResponseHandler);
        
        //submit from callback
        return false;
    });

})(jQuery);