(function($) {

    "use strict"; 
    var base_url = window.base_url;
    
    var tab = 'trainingrecords-attachments';

    var target = $('#'+tab).attr('target');

    var bar = $('#'+tab+' > .progress > .bar');

    var percent = $('#'+tab+' > .progress > .percent');

    var progress = $('#'+tab+' > .progress');   

    $('#'+tab+' > form').ajaxForm({

        beforeSend: function() {

            progress.show();

            var percentVal = '0%';

            bar.width(percentVal)

            percent.html(percentVal);

        },

        uploadProgress: function(event, position, total, percentComplete) {

            var percentVal = percentComplete + '%';

            bar.width(percentVal)

            percent.html(percentVal);

            

        },

        success: function() {

            var percentVal = '100%';

            bar.width(percentVal)

            percent.html(percentVal);

        },

        complete: function(xhr) {

            

            var response = jQuery.parseJSON(xhr.responseText);

            if(response.error==0)

            {               

                window.parent.$('#user_photo').attr("src",base_url+'uploads/profile_photos/'+response.name);

                window.parent.$('#profile_photo').attr("value",response.name);

            }

            else

            {



                var error = '<label class="col-lg-2 control-label">&nbsp;</label><div class="col-lg-8"><div class="alert alert-danger" style="margin-bottom:0;">'+response.error+'</div></div>';

                window.parent.$('#profile_photo_error').html(error);

            }





            var percentVal = '0%';

            bar.width(percentVal)

            percent.html(percentVal);

            progress.hide();

            

        }

    });    
    
})(jQuery);