(function() {

    var site_url = window.site_url;
    var base_url = window.base_url;


    var t = $(".memento-nav .dropdown-toggle > .fa-bell + .badge");
    if ($(t).length > 0 && parseInt($(t).html()) > 0) {
        $(".memento-nav .dropdown-toggle > .fa-bell").addClass("anim-swing")
    }
    t = $(".memento-nav .dropdown-toggle > .fa-envelope + .badge");
    if ($(t).length > 0 && parseInt($(t).html()) > 0) {
        $(".memento-nav .dropdown-toggle > .fa-envelope").addClass("anim-top-down")
    }
    $(".show-tooltip").tooltip({
        container: "body",
        delay: {
            show: 500
        }
    });
    
    $('*[inline-class]').each(function(){
        var inline = $(this).attr('inline-class');
        $(this).addClass(inline);
    });

    $('[data-toggle="tooltip"]').tooltip();

    $('#position').on('change',function(){
        $('#position-form').trigger('submit');
    });

    $('#all-posts').DataTable( {
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    } );    
    
    $('.select-to-none').on('click',function(e){
        e.preventDefault();
        $('#to option').prop('selected', false);
    });

    $('.select-to-all').on('click',function(e){
        e.preventDefault();
        $('#to option').prop('selected', true);
    });

    $(".edit-widget").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#editWidgetModal').modal('show');
        $("#editWidgetModal  .modal-body").html("Loading...");
        $.post(
                loadUrl,
                {},
                function(responseText){
                    $("#editWidgetModal  .modal-body").html(responseText);
                },
                "html"
            );
    });

    $( "ol.droptrue" ).sortable({
        connectWith: "ol"
    });

    $( "#sortable1, #sortable2" ).disableSelection();
    

    $('.show-widget-positions').on('click',function(e){
        e.preventDefault();
        $('#position-instruction').modal('show');
    });

    $(".edit-widget").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#editWidgetModal').modal('show');
        $("#editWidgetModal  .modal-body").html("Loading...");
        $.post(
                loadUrl,
                {},
                function(responseText){
                    $("#editWidgetModal  .modal-body").html(responseText);
                    edit_widget_js();
                },
                "html"
            );
    });

    $('#type').on('change',function(){
            var val = $(this).val();
            if(val=='news_source')
            {
                $('.news-source').show();
                $('.news-category').hide();                
            }
            else
            {
                $('.news-source').hide();
                $('.news-category').show();                
            }

    });

    $('#type').trigger('change');
    $('#package_type').on('change',function(e){
        var val = $(this).val();
        if(val=='post_package')
        {
            $('.gallery_limit_holder').show();
        }
        else
        {
            $('.gallery_limit_holder').hide();
        }
    });

    $('#package_type').trigger('change');

    function edit_widget_js()
    {
        $('#save-widget-form').on('submit',function(event){
            event.preventDefault();
            var loadUrl = $(this).attr('action');
            $("#editWidgetModal  .modal-body").html("Updating...");
            $.post(
                loadUrl,
                $(this).serialize(),
                function(responseText){
                    $("#editWidgetModal  .modal-body").html(responseText);
                    edit_widget_js();
                },
                "html"
            );

        });        
    }

    $( "#sorttable" ).sortable();


    $('#featured_photo_input').on('change',function(){
        var val = $(this).val();
        if(val!='')
        {
            var src = base_url+'uploads/thumbs/'+val;
        }
        else
        {
            var src = base_url+'assets/admin/img/preview.jpg'
        }
        $('#featured_photo').attr('src',src);
    });

    $('#featured_photo_input').trigger('change');

    $('.fav-input').on('keyup',function(){
        var val = $(this).val();
        $('.fa-preview').html('<i class="fa '+val+'"></i>');
    });

    $('.fav-input').trigger('keyup');


    $('#parent').on('change',function(){
        var val = $(this).val();
        if(val==0)
        {
            $('.icon-class-holder').show();
        }
        else
        {
            $('.fav-input').attr('placeholder',$('#parent > option:selected').attr('fav-class'));
            $('.icon-class-holder').hide();
        }

    });

    $('#parent').trigger('change');

    $(".create-conditions").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#option-modal').modal('show');
        $("#option-modal  .modal-body").html("Loading...");
        $.get(
                loadUrl,
                {},
                function(responseText){
                    $("#option-modal  .modal-body").html(responseText);
                    edit_amenity_js();
                },
                "html"
            );
    });

    $(".edit-option").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#option-modal').modal('show');
        $("#option-modal  .modal-body").html("Loading...");
        $.get(
                loadUrl,
                {},
                function(responseText){
                    $("#option-modal  .modal-body").html(responseText);
                    edit_amenity_js();
                },
                "html"
            );
    });

    $('#option-modal').on('hidden.bs.modal', function () {
        location.reload();
    });

 

    $(".detail").on('click',function(event){
        event.preventDefault();
        var id = $(this).attr('id');
        var msg = $('.msg-'+id).html();
        $('#location-model .modal-body').html(msg);
        $('#location-model').modal('show');
        
    });

function initPaging()
{
    all_posts_js();
      
    var page_num = window.page_num;
    $("#all-posts").on('click','.renew-featured',function(){
      var post_id = $(this).data("postid");
      var action = site_url+'admin/content/renewfeatured'+'/'+page_num+'/'+post_id+'/';

      $('#modal_form').attr("action",action);
      $('#modal_post_id').attr("value",post_id);
      $('#featuredModal').modal('show');
    });

    $("#all-posts").on('click','.make-featured',function(){
      
      var post_id = $(this).data("postid");
      var action = site_url+'admin/content/featurepost'+'/'+page_num+'/'+post_id+'/';

      $('#modal_form').attr("action",action);
      $('#modal_post_id').attr("value",post_id);
      $('#featuredModal').modal('show');
    });

    $('.ajax-pagination a').on('click',function(e){
        e.preventDefault();
        var load_url = $(this).attr('href');
        if(load_url!='#')
        {
          $('#table-search-from').attr('action',load_url);
          $('#table-search-from').trigger('submit');      
        }
    });
}

      $('#table-search-from').on('submit',function(e){
        e.preventDefault();
        $('.loading').show();
        var load_url = $(this).attr('action');
        $.post(
            load_url,
            {key:$('#key').val()},
            function(responseText){        
                $('.loading').hide();
                $('#no-more-tables').html(responseText);
                initPaging();
            }
        ); 
      });

      $('.search-plain').on('click',function(){
        $('#table-search-from').trigger('submit');
      });

      $('.search-plain').trigger('click');

      initPaging();

      function all_posts_js()
      {
        $('.check-all-ids').on('click',function(e){
          var checked = $(this).prop('checked');
          if(checked)
          {
            $('.ids').prop('checked',true);
            $('.delete-all').show();
          }
          else
          {
            $('.ids').prop('checked',false);
            $('.delete-all').show();
          }
        });

        $('.ids').on('click',function(e){
          var checked = $(this).prop('checked');
          if(!checked)
          {
            $('.check-all-ids').prop('checked',false);
            var flag = 0;
            $('.ids').each(function(){
              if($(this).prop('checked'))
                flag = 1;
            });
            if(flag==0)
            $('.delete-all').show();
          }
          else
          {
            $('.delete-all').show();
          }
        });

        $('.delete-all').on('click',function(e){
          e.preventDefault();
          var warning = "You sure want to delete?";
          var r = confirm(warning);
          if (r == true) {
            var load_url = site_url+"/admin/content/bulkdeletenews/";
            var id_array = Array();
            
            $('.ids').each(function(){
              if($(this).prop('checked'))
                id_array.push($(this).val());
            });
            $.post(
                load_url,
                {ids:id_array},
                function(responseText){        
                    $('#table-search-from').trigger('submit');
                }
            ); 
          }

        });

      }

    $(".add-location").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#location-model').modal('show');
        $("#location-model  .modal-body").html("Loading...");
        $.get(
                loadUrl,
                {},
                function(responseText){
                    $("#location-model  .modal-body").html(responseText);
                    edit_location_js();
                },
                "html"
            );
    });

    $(".edit-location").on('click',function(event){
        event.preventDefault();
        var loadUrl = $(this).attr("href");
        $('#location-model').modal('show');
        $("#location-model  .modal-body").html("Loading...");
        $.get(
                loadUrl,
                {},
                function(responseText){
                    $("#location-model  .modal-body").html(responseText);
                    edit_location_js();
                },
                "html"
            );
    });

    $('#location-model').on('hidden.bs.modal', function () {
        location.reload();
    });


    function edit_location_js()
    {
        $('#save-location-form').on('submit',function(event){
            event.preventDefault();
            var loadUrl = $(this).attr('action');
            $("#location-model  .modal-body").html("Updating...");
            $.post(
                loadUrl,
                $(this).serialize(),
                function(responseText){
                    $("#location-model  .modal-body").html(responseText);
                    edit_location_js();
                },
                "html"
            );

        });


        
        $('#country').on('change',function(){
            var val = $(this).val();
            var loadUrl = site_url+'/show/get_locations_by_parent_ajax/'+val;
            $.post(
                loadUrl,
                {},
                function(responseText){
                    $('#state').html(responseText);
                    var sel_country = '';
                    var sel_state   = '';
                    if(val==sel_country)
                    $('#state').val(sel_state);
                    else
                    $('#state').val('');
                    $('#state').focus();
                    $('#state').trigger('change');
                }
            );
         });   

        $('#country').trigger('change');

        var parent = $('.state-drop > option:selected').attr('parent');
                if(parent!='')
                    $('.country').val(parent);

    }

    $('#all-transaction').dataTable();

    $('.review-detail').on('click',function(e){
        e.preventDefault();
        var loadUrl = $(this).attr('href');
        $.post(
            loadUrl,
            {},
            function(responseText){
                $('#reviewModal .modal-body').html(responseText);
                $('#reviewModal').modal('show');
            }
        );

    });

    $('#show_banner').on('change',function(){
      var val = $(this).val();
      if(val=='Yes')
      {
        $('.show_banner_container').show();
      }    
      else
      {
        $('.show_banner_container').hide();

      }
    });

    $('#show_banner').trigger('change');

    $('#show_search_panel').on('change',function(){
      var val = $(this).val();
      if(val=='Yes')
      {
        $('.search_panel_container').show();
      }    
      else
      {
        $('.search_panel_container').hide();

      }
    });  

    $('#show_search_panel').trigger('change');  

    $('#map_type').on('change',function(e){
      var val = $(this).val();
      if(val=='Google')
      {
        $('.api-key-holder').show();
      }
      else
      {      
        $('.api-key-holder').hide();
      }
    });

    $('#map_type').trigger('change');

    $('#disable_map').on('change',function(e){
      var val = $(this).val();
      if(val=='Yes')
      {
        $('.map-option-holder').hide();
        $('.map-embed-option-holder').show();
      }
      else
      {
        $('.map-option-holder').show();        
        $('.map-embed-option-holder').hide();
      }
    });

    $('#disable_map').trigger('change');

    $('#banner_type').on('change',function(){
        var val = $(this).val();
        if(val=='Slider')
        {
            $('#slider-panel').show();
            $('#map-panel').hide();

        }
        else
        {
            $('#map-panel').show();
            $('#slider-panel').hide();
        }
    });

    $('#banner_type').trigger('change');

    $('#search_bg').on('change',function(){
            var val = $(this).val();
            var src = base_url+'assets/images/searchbg/'+val;
            $('#search_bg_preview').attr('src',src);
    });

    $('#search_bg').trigger('change');

    show_hide_image_panel();

    $('#show_bg_image').on('click',function(){
      show_hide_image_panel();
    });

    function show_hide_image_panel()
    {
      if($('#show_bg_image').attr('checked')=='checked')
      {
        $('.bg-img').show();
      }
      else
      {
        $('.bg-img').hide();
      }
    }

    $('#enable_bank_transfer').on('change',function(){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('.bank-transfer').show();

            if($('#enable_feature_payment').val()=='Yes')
                $('input[name=featured_payment_bank_instruction_rules]').val('required');
            else
                $('input[name=featured_payment_bank_instruction_rules]').val('');
            
            $('input[name=signup_payment_bank_instruction_rules]').val('required');
        }
        else
        {
            $('.bank-transfer').hide();
            $('input[name=featured_payment_bank_instruction_rules]').val('');
            $('input[name=signup_payment_bank_instruction_rules]').val('');
        }

    });

    $('#enable_bank_transfer').trigger('change');

    $('#enable_feature_payment').on('change',function(){
        var val =  $(this).val();
        if(val=='Yes')
        {
            $('input[name=feature_charge_rules]').val('required');
            $('input[name=feature_day_limit_rules]').val('required');
            $('#feature_payment_settings_panel').show();
        }
        else
        {
            $('input[name=feature_charge_rules]').val('');
            $('input[name=feature_day_limit_rules]').val('');
            $('#feature_payment_settings_panel').hide();            
        }
    });

    $('#enable_feature_payment').trigger('change');

    $('select[name=do_water_mark]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=water_mark_text_rules]').attr('value','required');
            $('#water_mark_text').show();
        }
        else
        {
            $('input[name=water_mark_text_rules]').attr('value','');            
            $('#water_mark_text').hide();
        }
    });

    $('select[name=do_water_mark]').trigger('change');

    $('select[name=enable_fb_login]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=fb_app_id_rules]').attr('value','required');
            $('input[name=fb_secret_key_rules]').attr('value','required');
            $('.fb-settings').show();
        }
        else
        {
            $('input[name=fb_app_id_rules]').attr('value','');
            $('input[name=fb_secret_key_rules]').attr('value','');
            $('.fb-settings').hide();
        }
    });

    $('select[name=enable_fb_login]').trigger('change');

    $('select[name=enable_share_button]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=sharethis_publisher_id_rules]').attr('value','required');
            $('#sharethis_publisher_id').show();
        }
        else
        {
            $('input[name=sharethis_publisher_id_rules]').attr('value','');
            $('#sharethis_publisher_id').hide();
        }
    });    

    $('select[name=enable_share_button]').trigger('change');

    $('select[name=hide_opening_hours]').on('change',function(e){
        var val = $(this).val();
        if(val=='No')
        {
            $('input[name=opening_hour_format_rules]').attr('value','required');
            $('.opening_hour_format_holder').show();
        }
        else
        {
            $('input[name=opening_hour_format_rules]').attr('value','');
            $('.opening_hour_format_holder').hide();
        }
    });    

    $('select[name=hide_opening_hours]').trigger('change');

    /* start facebook comment settings */

    $('select[name=enable_comment]').on('change',function(e){
        var val = $(this).val();
        if(val=='Facebook Comment')
        {
            $('input[name=fb_comment_app_id_rules]').attr('value','required');
            $('.fb-comment-settings').show();
        }
        else
        {
            $('input[name=fb_comment_app_id_rules]').attr('value','');
            $('.fb-comment-settings').hide();
        }

        if(val=='Disqus Comment')
        {
            $('input[name=disqus_shortname_rules]').attr('value','required');
            $('#disqus_shortname_holder').show();
        }
        else
        {
            $('input[name=disqus_shortname_rules]').attr('value','');
            $('#disqus_shortname_holder').hide();
        }
    });

    $('select[name=enable_comment]').trigger('change');

        $('select[name=enable_blog_comment]').on('change',function(e){
        var val = $(this).val();
        if(val=='Facebook Comment')
        {
            $('input[name=fb_blog_comment_app_id_rules]').attr('value','required');
            $('.fb-blog-comment-settings').show();
        }
        else
        {
            $('input[name=fb_blog_comment_app_id_rules]').attr('value','');
            $('.fb-blog-comment-settings').hide();
        }

        if(val=='Disqus Comment')
        {
            $('input[name=disqus_blog_shortname_rules]').attr('value','required');
            $('#disqus_blog_shortname_holder').show();
        }
        else
        {
            $('input[name=disqus_blog_shortname_rules]').attr('value','');
            $('#disqus_blog_shortname_holder').hide();
        }
    });

    $('select[name=enable_blog_comment]').trigger('change');

    /* end facebook comment settings*/

    $('select[name=enable_gplus_login]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=gplus_app_id_rules]').attr('value','required');
            $('input[name=gplus_secret_key_rules]').attr('value','required');
            $('.gplus-settings').show();
        }
        else
        {
            $('input[name=gplus_app_id_rules]').attr('value','');
            $('input[name=gplus_secret_key_rules]').attr('value','');
            $('.gplus-settings').hide();
        }
    });

    $('select[name=enable_gplus_login]').trigger('change');

    $('select[name=enable_cookie_policy_popup]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=cookie_policy_page_url_rules]').attr('value','required');
            $('.cookie-policy-settings').css('display','flex');
        }
        else
        {
            $('input[name=cookie_policy_page_url_rules]').attr('value','');
            $('.cookie-policy-settings').css('display','none');
        }
    });   

    $('select[name=enable_cookie_policy_popup]').trigger('change'); 

        $('#sidebarCollapse').on('click', function (e) {
            e.preventDefault();
            $('#sidebar, #content').toggleClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
        });

        $('#maximize').on('click', function (e) {
            e.preventDefault();
            $('#sidebar, #content').toggleClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            if($('#sidebar').hasClass('active'))
            {
              $('#maximize').html('<span class="fa fa-compress"></span>');
            }
            else
            {
              $('#maximize').html('<span class="fa fa-expand"></span>');
            }
        });

        $('#sidebar > .components > .active').each(function(){
            if($(this).hasClass('active'))
            {
              $(this).find('a').trigger('click');
            }
        });


    $('#sel_tmpl').on('change',function(){
        $('#edit_tmpl').attr('href',site_url+'admin/system/emailtmpl/'+$(this).val());
    });

    $('.show').on('click',function(e){
        e.preventDefault();
        $('.sample-content').toggle();
    });

        $('#featured_photo_input_offer').on('change',function(){
            var val = $(this).val();
            if(val!='')
            {
                var src = base_url+'uploads/offers/thumbs/'+val;
            }
            else
            {
                var src = base_url+'assets/admin/img/preview.jpg'
            }
            $('#featured_photo').attr('src',src);
        });

        $('#featured_photo_input_offer').trigger('change');

        $('#activation_date').datetimepicker();
        $('#expirtion_date').datetimepicker();

        $('#has_time_limit').on('click',function(e){
            show_hide_time();
        });
        show_hide_time();

    function show_hide_time()
    {
        var val = $('#has_time_limit').prop('checked');
        if(val)
        {
            $('.time-limit-container').show();
        }
        else
        {
            $('.time-limit-container').hide();
        }
    }

    $('#enable_bank_transfer').on('change',function(){
        var val = $(this).val();
        if(val=='Yes')
            $('input[name=bank_transfer_instruction_for_posts_rules]').val('required');
        else
            $('input[name=bank_transfer_instruction_for_posts_rules]').val('');
    });

    $('#enable_bank_transfer').trigger('change');

    $('#enable_featured_bank_transfer').on('change',function(){
        var val = $(this).val();
        if(val=='Yes')
            $('input[name=bank_transfer_instruction_for_featured_posts_rules]').val('required');
        else
            $('input[name=bank_transfer_instruction_for_featured_posts_rules]').val('');
    });

    $('#enable_featured_bank_transfer').trigger('change');

    var updateOutput = function(e)
    {
       
    };

    // activate Nestable for list 1
    $('#nestable').nestable({
        group: 1
    })
    .on('change', updateOutput);
    

    // output initial serialised data
    updateOutput($('#nestable').data('output', $('#nestable-output')));

    $('#nestable-menu').on('click', function(e)
    {
        var target = $(e.target),
            action = target.data('action');
        if (action === 'expand-all') {
            $('.dd').nestable('expandAll');
        }
        if (action === 'collapse-all') {
            $('.dd').nestable('collapseAll');
        }
    });
    $('#menu-form').on('submit',function(e){
        var data = [];
		$('.dd-item').each(function(){
			var id 		= $(this).attr('data-id');
			var parent  = $(this).parent().parent().attr('data-id');
			if(typeof parent == 'undefined')
				parent = 0;
			var menu = {'id':id,'parent':parent};
            data.push(menu);
		}); 
        $('#top_menu').val(JSON.stringify(data));
    });

    $('#profile_photo').on('change',function(){

        var val = $(this).val();
        var src = base_url+'uploads/profile_photos/thumb/'+val;        

        if(val=='nophoto-male.jpg')
        {            
            src = base_url+'assets/images/nophoto.jpg';        
        }

        $('#user_photo').attr('src',src);

    });

    $('#profile_photo').trigger('change');

    $('#enable_watermarking').on('change',function(){
        var val  = $(this).val();
        if(val=='No')
        {
            $('.watermark-holder').hide();
        }
        else
        {
            $('.watermark-holder').show();                
        }
    });

    $('#enable_watermarking').trigger('change');

    $('#enable_smtp').on('change',function(){
        var val = $(this).val();
        if(val=='Enable')
        {
            $('#enable-panel').show();            
        }
        else
        {
            $('#enable-panel').hide();
        }
    });

    $('#enable_smtp').trigger('change');

	$('#featured_photo_input_slider').on('change',function(){
        var val = $(this).val();
        if(val!='')
        {
          var src = base_url+'uploads/slider/'+val;            
        }
        else
        {
          var src = base_url+'assets/admin/img/preview.jpg'
        }
        $('#featured_photo').attr('src',src);
    });

    $('#featured_photo_input_slider').trigger('change');

    $('.check-all').on('click',function(e){
      e.preventDefault();
      $('.item').prop('checked',true);
    });

    $('.un-check-all').on('click',function(e){
      e.preventDefault();
      $('.item').prop('checked',false);
    });

    $('#user_type').on('change',function(){
        var val = $(this).val();
        if(val==3)
        {
            $('.company-holder').hide();
        }
        else
        {            
            $('.company-holder').show();
        }
    });

    $('#user_type').trigger('change');    



    var fixHelper = function(e, ui) {
      ui.children().each(function() {
        $(this).width($(this).width());
      });
      return ui;
    };

    $("#sort tbody").sortable({
      helper: fixHelper
    }).disableSelection();


    function edit_amenity_js()
    {
        $('#save-option-form').on('submit',function(event){
            event.preventDefault();
            var loadUrl = $(this).attr('action');
            $("#option-modal  .modal-body").html("Updating...");
            $.post(
                loadUrl,
                $(this).serialize(),
                function(responseText){
                    $("#option-modal  .modal-body").html(responseText);
                    edit_amenity_js();
                },
                "html"
            );

        });  

        $('#fieldtitle').on('keyup',function(){
            var val = $(this).val();
            var desired = val.replace(/[\W]/g,'');
            $('#fieldname').val(desired);
        });

        $('#fieldname').on('keyup',function(){
            var val = $(this).val();

            var excludes = ["[", "]"];
            var output = val.replace(/[_\W]/g, function(match){
              if ( excludes.indexOf(match) == -1 )
              {  
                match = "_";
              }
              return match;
            }) ;

            $('#fieldname').val(output);
        });

    }

    $('.rich').each(function(){
        var id = $(this).attr('id');
        $("#"+id).richText({code: false});
    });

    $('#featured_photo_input').on('change',function(){
        var val = $(this).val();
        if(val!='')
        {
          var src = base_url+'uploads/thumbs/'+val;            
        }
        else
        {
          var src = base_url+'assets/admin/img/preview.jpg'
        }
        $('#featured_photo').attr('src',src);
    });

    $('#featured_photo_input').trigger('change');


    $('.submit').on('click',function(e){

        $('#action').val($(this).attr('action'));

    });



    $('#content_from').on('change',function(){

        var content_from = $(this).val();

        if(content_from=='Manual')

        {

            $('.manual').show();

            $('.url').hide();

        }

        else

        {

            $('.manual').hide();

            $('.url').show();          

        }

        $('#layout').trigger('change');

    });

    $('#content_from').trigger('change');


    $('#title').on('keyup',function(e){

        makealias($(this).val());

    });



    $('#title').on('change',function(e){

        makealias($(this).val());

    });

    $('#title').trigger('change');

function makealias(val)

{

    val = val.toLowerCase();

    val = val.replace(/\s/g, '');

    val = val.replace('[', '');

    val = val.replace(']', '');

    if($('#alias').val()=='')
    {        
        $('#alias').val(val);
    }

}



$('#layout').on('change',function(){

    var val = $(this).val();
    if(val==2)

    {

        $('.left-bar').hide();

        $('.right-bar').hide();

        $('.main-content').css('width','100%');

    }

    else if(val==0)

    {

        $('.left-bar').show();

        $('.right-bar').hide();

        $('.main-content').css('width','75%');

        

    }

    else if(val==1)

    {

        $('.left-bar').hide();

        $('.right-bar').show();

        $('.main-content').css('width','75%');     

    }       

});

$('#layout').trigger('change');

    $('.filters').on('change',function(){
        $('#filter_form').trigger('submit');
    });

    $(".detail").on('click',function(event){
        event.preventDefault();
        var id = $(this).attr('id');
        var msg = $('.msg-'+id).html();
        $('#location-model .modal-body').html(msg);
        $('#location-model').modal('show');
        
    });    
    window.prettyPrint && prettyPrint();
    var n = function() {
        if ($("#sidebar.sidebar-fixed").length == 0) {
            $("#sidebar .nav").css("height", "auto");
            return
        }
        if ($("#sidebar.sidebar-fixed.sidebar-collapsed").length > 0) {
            $("#sidebar .nav").css("height", "auto");
            return
        }
        var e = $(window).height() - 90;
        $("#sidebar.sidebar-fixed .nav").slimScroll({
            height: e + "px",
            position: "left"
        })
    };
    n();
    $("#sidebar a.dropdown-toggle").on('click',function() {
        var e = $(this).next(".submenu");
        var t = $(this).children(".arrow");
        if (t.hasClass("fa-angle-right")) {
            t.addClass("anim-turn90")
        } else {
            t.addClass("anim-turn-90")
        }
        e.slideToggle(400, function() {
            if ($(this).is(":hidden")) {
                t.attr("class", "arrow fa fa-angle-right")
            } else {
                t.attr("class", "arrow fa fa-angle-down")
            }
            t.removeClass("anim-turn90").removeClass("anim-turn-90")
        })
    });
    $("#sidebar.sidebar-collapsed #sidebar-collapse > i").attr("class", "fa fa-angle-double-right");
    $("#sidebar-collapse").on('click',function() {
        $("#sidebar").toggleClass("sidebar-collapsed");
        if ($("#sidebar").hasClass("sidebar-collapsed")) {
        	$('.navbar-brand span').hide();
        	$('.navbar-brand').css('width','42px');
            $("#sidebar-collapse > i").attr("class", "fa fa-angle-double-right");
            $.cookie("sidebar-collapsed", "true");
            $("#sidebar ul.nav-list").parent(".slimScrollDiv").replaceWith($("#sidebar ul.nav-list"))
        } else {
        	$('.navbar-brand span').show();
        	$('.navbar-brand').css('width','250px');
            $("#sidebar-collapse > i").attr("class", "fa fa-angle-double-left");
            $.cookie("sidebar-collapsed", "false");
            n()
        }
    });
    $("#sidebar").on("show.bs.collapse", function() {
        if ($(this).hasClass("sidebar-collapsed")) {
            $(this).removeClass("sidebar-collapsed")
        }
    });
    $("#sidebar .search-form").on('click',function() {
        $('#sidebar .search-form input[type="text"]').focus()
    });
    $("#sidebar .nav > li.active > a > .arrow").removeClass("fa-angle-right").addClass("fa-angle-down");
    if ($("#nav-horizontal")) {
        var r = function() {
            var e = $(window).width();
            if (e > 979) {
                $("#nav-horizontal").removeClass("nav-xs");
                $("#nav-horizontal .arrow").removeClass("fa-angle-right").removeClass("fa-angle-down").addClass("fa-caret-down")
            } else {
                $("#nav-horizontal").addClass("nav-xs");
                $("#nav-horizontal .arrow").removeClass("fa-caret-down").addClass("fa-angle-right")
            }
        };

        $(window).on('resize',function() {
            r()
        });

        r()
    }
    $("#nav-horizontal a.dropdown-toggle").on('click',function() {
        var e = $(this).next(".dropdown-menu");
        var t = $(this).children(".arrow");
        if ($("#nav-horizontal.nav-xs").length > 0) {
            if (t.hasClass("fa-angle-right")) {
                t.addClass("anim-turn90")
            } else {
                t.addClass("anim-turn-90")
            }
        }
        if ($("#nav-horizontal.nav-xs").length == 0) {
            $("#nav-horizontal > li > .dropdown-menu").not(e).slideUp(400)
        }
        e.slideToggle(400, function() {
            if ($("#nav-horizontal.nav-xs").length > 0) {
                if ($(this).is(":hidden")) {
                    t.attr("class", "arrow fa fa-angle-right")
                } else {
                    t.attr("class", "arrow fa fa-angle-down")
                }
                t.removeClass("anim-turn90").removeClass("anim-turn-90")
            }
        })
    });
    $("#theme-setting > a").on('click',function() {
        $(this).next().animate({
            width: "toggle"
        }, 500, function() {
            if ($(this).is(":hidden")) {
                $("#theme-setting > a > i").attr("class", "fa fa-gears fa-2x")
            } else {
                $("#theme-setting > a > i").attr("class", "fa fa-times fa-2x")
            }
        });
        $(this).next().css("display", "inline-block")
    });
    $("#theme-setting ul.colors a").on('click',function() {
        var e = $(this).parent().get(0);
        var t = $(e).parent().get(0);
        var n = $(t).data("target");
        var r = $(t).data("prefix");
        var i = $(this).attr("class");
        var s = new RegExp("\\b" + r + ".*\\b", "g");
        $(t).children("li").removeClass("active");
        $(e).addClass("active");
        if ($(n).attr("class") != undefined) {
            $(n).attr("class", $(n).attr("class").replace(s, "").trim())
        }
        $(n).addClass(r + i);
        if (n == "body") {
            var o = $(t).parent().get(0);
            var u = $(o).nextAll("li:lt(2)");
            $(u).find("li.active").removeClass("active");
            $(u).find("a." + i).parent().addClass("active");
            $("#navbar").attr("class", $("#navbar").attr("class").replace(/\bnavbar-.*\b/g, "").trim());
            $("#main-container").attr("class", $("#main-container").attr("class").replace(/\bsidebar-.*\b/g, "").trim())
        }
        $.cookie(r + "color", i)
    });
    var i = ["blue", "red", "green", "orange", "yellow", "pink", "magenta", "gray", "black"];
    $.each(i, function(e, t) {
        if ($("body").hasClass("skin-" + t)) {
            $("#theme-setting ul.colors > li").removeClass("active");
            $("#theme-setting ul.colors > li:has(a." + t + ")").addClass("active")
        }
    });
    $.each(i, function(e, t) {
        if ($("#navbar").hasClass("navbar-" + t)) {
            $('#theme-setting ul[data-prefix="navbar-"] > li').removeClass("active");
            $('#theme-setting ul[data-prefix="navbar-"] > li:has(a.' + t + ")").addClass("active")
        }
        if ($("#main-container").hasClass("sidebar-" + t)) {
            $('#theme-setting ul[data-prefix="sidebar-"] > li').removeClass("active");
            $('#theme-setting ul[data-prefix="sidebar-"] > li:has(a.' + t + ")").addClass("active")
        }
    });
    if ($("#sidebar").hasClass("sidebar-fixed")) {
        $('#theme-setting > ul > li > a[data-target="sidebar"] > i').attr("class", "fa fa-check-square-o green")
    }
    if ($("#navbar").hasClass("navbar-fixed")) {
        $('#theme-setting > ul > li > a[data-target="navbar"] > i').attr("class", "fa fa-check-square-o green")
    }
    $("#theme-setting > ul > li > a").on('click',function() {
        var e = $(this).data("target");
        var t = $(this).children("i");
        if (t.hasClass("fa-square-o")) {
            t.attr("class", "fa fa-check-square-o green");
            $("#" + e).addClass(e + "-fixed");
            $.cookie(e + "-fixed", "true")
        } else {
            t.attr("class", "fa fa-square-o");
            $("#" + e).removeClass(e + "-fixed");
            $.cookie(e + "-fixed", "false")
        }
        if (e == "sidebar") {
            if (t.hasClass("fa-square-o")) {
                $("#sidebar ul.nav-list").parent(".slimScrollDiv").replaceWith($("#sidebar ul.nav-list"))
            }
            n()
        }
    });
    $(".box .box-tool > a").on('click',function(e) {
        if ($(this).data("action") == undefined) {
            return
        }
        var t = $(this).data("action");
        var n = $(this);
        switch (t) {
            case "collapse":
                $(n).children("i").addClass("anim-turn180");
                $(this).parents(".box").children(".box-content").slideToggle(500, function() {
                    if ($(this).is(":hidden")) {
                        $(n).children("i").attr("class", "fa fa-chevron-down")
                    } else {
                        $(n).children("i").attr("class", "fa fa-chevron-up")
                    }
                });
                break;
            case "close":
                $(this).parents(".box").fadeOut(500, function() {
                    $(this).parent().remove()
                });
                break;
            case "config":
                $("#" + $(this).data("modal")).modal("show");
                break
        }
        e.preventDefault()
    });
    $(".mail-messages .msg-collapse > a").on('click',function(e) {
        $(this).children("i").addClass("anim-turn180");
        $(this).parents("li").find(".mail-msg-container").slideToggle(500, function() {
            var e = $(this).parents("li").find(".msg-collapse > a").children("i");
            if ($(this).is(":hidden")) {
                $(e).attr("class", "fa fa-chevron-down")
            } else {
                $(e).attr("class", "fa fa-chevron-up")
            }
        })
    });
    $(".mail-content i.fa-star").on('click',function() {
        $(this).toggleClass("starred")
    });
    $('.mail-toolbar > li:first-child > input[type="checkbox"]').on('change',function() {
        var e = false;
        if ($(this).is(":checked")) {
            e = true
        }
        $(this).parents(".mail-content").find('.mail-list .ml-left > input[type="checkbox"]').prop("checked", e);
        var t = $(this).parents(".mail-content").find(".mail-list > li");
        if (e) {
            $(t).addClass("checked")
        } else {
            $(t).removeClass("checked")
        }
    });
    $('.mail-list .ml-left > input[type="checkbox"]').on('change',function() {
        if ($(this).is(":checked")) {
            $(this).parents("li").addClass("checked")
        } else {
            $(this).parents("li").removeClass("checked")
        }
    });
    $(window).scroll(function() {
        if ($(this).scrollTop() > 100) {
            $("#btn-scrollup").fadeIn()
        } else {
            $("#btn-scrollup").fadeOut()
        }
    });
    $("#btn-scrollup").on('click',function() {
        $("html, body").animate({
            scrollTop: 0
        }, 600);
        return false
    });
    if ($(".tile-active").length > 0) {
        var s = 1500;
        var o = 5e3;
        var u = function(e, t, n, r) {
            $(e).children(".tile").animate({
                top: "-=" + r + "px"
            }, s);
            setTimeout(function() {
                a(e, t, n, r)
            }, n + s)
        };
        var a = function(e, t, n, r) {
            $(e).children(".tile").animate({
                top: "+=" + r + "px"
            }, s);
            setTimeout(function() {
                u(e, t, n, r)
            }, t + s)
        };
        $(".tile-active").each(function(e, t) {
            var n, r, i, s, a;
            n = $(this).children(".tile").first();
            r = $(this).children(".tile").last();
            i = $(n).data("stop");
            s = $(r).data("stop");
            a = $(n).outerHeight();
            if (i == undefined) {
                i = o
            }
            if (s == undefined) {
                s = o
            }
            setTimeout(function() {
                u(t, i, s, a)
            }, i)
        })
    }
    $('.table > thead > tr > th:first-child > input[type="checkbox"]').on('change',function() {
        var e = false;
        if ($(this).is(":checked")) {
            e = true
        }
        $(this).parents("thead").next().find('tr > td:first-child > input[type="checkbox"]').prop("checked", e)
    });
    $('.table > tbody > tr > td:first-child > input[type="checkbox"]').on('change',function() {
        var e = false;
        if ($(this).is(":checked")) {
            e = true
        }
        if (!e) {
            $('.table > thead > tr > th:first-child > input[type="checkbox"]').prop("checked", false)
        }
    });
    if ($().dataTable) {
        $("#table1").dataTable({
            aLengthMenu: [
                [10, 15, 25, 50, 100, -1],
                [10, 15, 25, 50, 100, "All"]
            ],
            iDisplayLength: 10,
            oLanguage: {
                sLengthMenu: "_MENU_ Records per page",
                sInfo: "_START_ - _END_ of _TOTAL_",
                sInfoEmpty: "0 - 0 of 0",
                oPaginate: {
                    sPrevious: "Prev",
                    sNext: "Next"
                }
            },
            aoColumnDefs: [{
                bSortable: false,
                aTargets: [0]
            }]
        })
    }
    if ($().chosen) {
        $(".chosen").chosen({
            no_results_text: "Oops, nothing found!",
            width: "100%"
        });
        $(".chosen-with-diselect").chosen({
            allow_single_deselect: true,
            width: "100%"
        })
    }
    if ($().pwstrength) {
        $('input[data-action="pwindicator"]').pwstrength()
    }
    if ($().bootstrapDualListbox) {
        $('select[data-action="duallistbox"]').bootstrapDualListbox()
    }
    if ($().colorpicker) {
        $(".colorpicker-default").colorpicker({
            format: "hex"
        });
        $(".colorpicker-rgba").colorpicker()
    }
    if ($().timepicker) {
        $(".timepicker-default").timepicker();
        $(".timepicker-24").timepicker({
            minuteStep: 1,
            showSeconds: true,
            showMeridian: false
        })
    }
    if ($().datepicker) {
        $(".date-picker").datepicker()
    }
    if ($().daterangepicker) {
        $(".date-range").daterangepicker()
    }
    if ($().wysihtml5) {
        $(".wysihtml5").wysihtml5()
    }
    if ($().validate) {
        var f = function(e) {
            $(e).closest(".form-group").removeClass("has-success")
        };
        var l = $("#validation-form").validate({
            errorElement: "span",
            errorClass: "help-block",
            errorPlacement: function(e, t) {
                if (t.parent(".input-group").length) {
                    e.insertAfter(t.parent())
                } else {
                    e.insertAfter(t)
                }
            },
            focusInvalid: false,
            ignore: "",
            invalidHandler: function(e, t) {},
            highlight: function(e) {
                $(e).closest(".form-group").removeClass("has-success").addClass("has-error")
            },
            unhighlight: function(e) {
                $(e).closest(".form-group").removeClass("has-error");
                setTimeout(function() {
                    f(e)
                }, 3e3)
            },
            success: function(e) {
                e.closest(".form-group").removeClass("has-error").addClass("has-success")
            }
        })
    }
    if ($().prettyPhoto) {
        $(".gallery a[rel^='prettyPhoto']").prettyPhoto({
            social_tools: "",
            hideflash: true
        })
    }

    $('#lang_name').on('change',function(){
        $('#lang-sel-form').submit();
    });

    $('.remove-lang-key').on('click',function(e){
        e.preventDefault();
        $(this).parent().parent().parent().remove();
    });

    $('#add_another_key').on('click',function(e){
        e.preventDefault();
        html = '<li>'+
                '<div class="row">'+
                  '<div class="col-md-3 col-sm-12">'+
                    '<input type="text" class="form-control form-control-sm lang_key" name="lang_key[]" value="">'+
                  '</div>'+
                  '<div class="col-md-4 col-sm-12">'+
                    '<input type="text" class="form-control form-control-sm lang_val" name="lang_val[]" value="">'+                  
                  '</div>'+
                  '<div class="col-md-5 col-sm-12">'+
                    '<a href="#" class="red remove-lang-key"><span class="fa fa-times"></span></a>'+
                  '</div>'+
                '</div>'+
              '</li>';
        $('#lang-key-holder').append(html);

        $('.remove-lang-key').on('click',function(e){
            e.preventDefault();
            $(this).parent().parent().parent().remove();
        });
    });

    $('#up-lang-data').on('click',function(e){
        e.preventDefault();
        var inp = "";
        $('.lang_key').each(function(){
            var key = $(this).val();
            var val = $(this).parent().parent().find('.lang_val').val();
            inp += key+'='+val+'#';
        });

        var lang_name = $('#lang_name').val();
        $('#lang-edit-form').append('<input type="hidden" name="lang_name" value="'+lang_name+'">');
        $('#lang-edit-form').append('<input type="hidden" name="data" value="'+inp+'">');
        $('#lang-edit-form').submit();
    });

    $('#full-text-detail').on('click',function(e){
        e.preventDefault();
        $('#full-text-modal').modal('show');
    });

    $('#parent_category').on('change',function(){
        var val = $(this).val();
        if(val=='')
            val = 0;
        var loadUrl = site_url+'/show/load_sub_categories/'+val;
        jQuery.post(
            loadUrl,
            {},
            function(responseText){
                $('#sub_category').html(responseText);

                var parent_category = $('#parent_category').val();

                var sub_category = $('#sub_category').val();            

                if(parent_category==val)
                {
                    if(sub_category==0)
                    $('#sub_category').val("");
                    else
                    $('#sub_category').val(sub_category);
                }
                else
                {
                    $('#sub_category').val("");                    
                }
            }
        );

    });

    $('#parent_category').trigger('change');    

    $('#auto_grabbing').on('change',function(){
        var val = $(this).val();
        if(val==1)
        {
            $('.auto_grabbing_options').show('slow');
        }
        else
        {
            $('.auto_grabbing_options').hide('slow');          
        }

    });

    $('#auto_grabbing').trigger('change');


    $('#grab_full_news').on('change',function(){
         var val = $(this).val();
         if(val==1)
         {            
            $('#item_per_grab option').each(function(){
                var item = $(this).val();
                if(item>3)
                {
                    $(this).hide();
                }
            });
         }
         else
         {
            $('#item_per_grab option').each(function(){
                var item = $(this).val();
                if(item>3)
                {
                    $(this).show();
                }
            });            
         }
    });

    $('#grab_full_news').trigger('change');

    $('#source_type').on('change',function(e){
        var val = $(this).val();
        if(val=='feed')
        {
            $('.rss-url').show();
        }
        else
        {
            $('.rss-url').hide();
        }
    });

    $('#source_type').trigger('change');


    $( ".date" ).datepicker({ dateFormat: 'dd-mm-yy' });


    $('#category').on('change',function(e){
        var val = $(this).val();
        if(val!='')
        {
            var loadUrl = site_url+'/show/load_sub_categories/'+val;
            jQuery.post(
                loadUrl,
                {},
                function(responseText){
                    $('#sub_category').html(responseText);

                    var parent_category = $('#parent_category').val();

                    var sub_category = $('#sub_category').val();            

                    if(parent_category==val)
                    {
                        if(sub_category!=0)
                        $('#sub_category').val(sub_category);
                        else
                        $('#sub_category').val("");                            
                    }
                    else
                    {
                        $('#sub_category').val("");                            
                    }
                }
            );                
        }
    });

    $('#category').trigger('change');

    $('#featured_photo_input').on('change',function(){
        var val = $(this).val();
        if(val!='')
        {
            var src = base_url+'uploads/images/'+val;
        }
        else
        {
            var src = base_url+'assets/admin/img/preview.jpg'
        }
        $('#featured_photo').attr('src',src);
        $('#media').attr('value',src);
    });

    function IsValidImageUrl(url) {
        $("<img>", {
            src: url,
            error: function() { 
                var src = base_url+'assets/admin/img/preview.jpg'
            },
            load: function() {

                $('#featured_photo').attr('src',url);
            }
        });
    }

    $('#media').on('change',function(){
        var src = $(this).val();
        IsValidImageUrl(src);
    });

    $('#media').trigger('change');


    function clearnews() {
        var txt;
        var r = confirm($('#undo_msg').val());
        if (r == true) {
            return true;
        } else {
            return false;
        }
    }

    $('select[name=enable_fb_login]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=fb_app_id_rules]').attr('value','required');
            $('input[name=fb_secret_key_rules]').attr('value','required');
            $('.fb-settings').show();
        }
        else
        {
            $('input[name=fb_app_id_rules]').attr('value','');
            $('input[name=fb_secret_key_rules]').attr('value','');
            $('.fb-settings').hide();
        }
    });
    $('select[name=enable_fb_login]').trigger('change');

    /* start facebook comment settings */

    $('select[name=enable_comment]').on('change',function(e){
        var val = $(this).val();
        if(val=='Facebook Comment')
        {
            $('input[name=fb_comment_app_id_rules]').attr('value','required');
            $('.fb-comment-settings').show();
        }
        else
        {
            $('input[name=fb_comment_app_id_rules]').attr('value','');
            $('.fb-comment-settings').hide();
        }

        if(val=='Disqus Comment')
        {
            $('input[name=disqus_shortname_rules]').attr('value','required');
            $('#disqus_shortname_holder').show();
        }
        else
        {
            $('input[name=disqus_shortname_rules]').attr('value','');
            $('#disqus_shortname_holder').hide();
        }
    });

    $('select[name=enable_comment]').trigger('change');

    /* end facebook comment settings*/

    $('select[name=enable_gplus_login]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=gplus_app_id_rules]').attr('value','required');
            $('input[name=gplus_secret_key_rules]').attr('value','required');
            $('.gplus-settings').show();
        }
        else
        {
            $('input[name=gplus_app_id_rules]').attr('value','');
            $('input[name=gplus_secret_key_rules]').attr('value','');
            $('.gplus-settings').hide();
        }
    });

    $('select[name=enable_gplus_login]').trigger('change');

    $('select[name=enable_cookie_policy_popup]').on('change',function(e){
        var val = $(this).val();
        if(val=='Yes')
        {
            $('input[name=cookie_policy_page_url_rules]').attr('value','required');
            $('.cookie-policy-settings').show();
        }
        else
        {
            $('input[name=cookie_policy_page_url_rules]').attr('value','');
            $('.cookie-policy-settings').hide();
        }
    });

    $('select[name=enable_cookie_policy_popup]').trigger('change');


})(jQuery);