(function($) {

    "use strict"; 
    var base_url = window.base_url;

    var tab = 'trainingrecords-attachments';
    var target = $('#'+tab).attr('target');
    var bar = $('#'+tab+' > .progress > .bar');
    var percent = $('#'+tab+' > .progress > .percent');
    var progress = $('#'+tab+' > .progress');   
    $('#'+tab+' > form').ajaxForm({
        beforeSend: function() {
            progress.show();
            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        uploadProgress: function(event, position, total, percentComplete) {
            var percentVal = percentComplete + '%';
            bar.width(percentVal)
            percent.html(percentVal);
            
        },
        success: function() {
            var percentVal = '100%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        complete: function(xhr) {
            
            var response = jQuery.parseJSON(xhr.responseText);
            if(response.error==0)
            {
                
                window.parent.$('#featured_photo_input').attr("value",response.name);
                window.parent.$('#featured_photo').attr("src",base_url+'location/'+response.name);
                window.parent.$('#featured_photo_input').trigger('change');
            }
            else
            {
                if(response.error=='upload_invalid_min_dimensions')
                    response.error = 'Image needs to be minimum 256x256 px';
                var error = '<label class="col-sm-3 col-lg-2">&nbsp;</label><div class="col-sm-4 col-lg-5"><div class="alert alert-danger" style="margin-bottom:0;">'+response.error+'</div></div>';
                window.parent.$('#featured-photo-error').html(error);
            }


            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
            progress.hide();
            
        }
    });
    
})(jQuery);