(function($) {

    "use strict"; 
    var base_url = window.base_url;

    var tab = 'trainingrecords-attachments';
    var target = $('#'+tab).attr('target');
    var bar = $('#'+tab+' > .progress > .bar');
    var percent = $('#'+tab+' > .progress > .percent');
    var progress = $('#'+tab+' > .progress');   
    $('#'+tab+' > form').ajaxForm({
        beforeSend: function() {
            progress.show();
            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        uploadProgress: function(event, position, total, percentComplete) {
            var percentVal = percentComplete + '%';
            bar.width(percentVal)
            percent.html(percentVal);
            
        },
        success: function() {
            var percentVal = '100%';
            bar.width(percentVal)
            percent.html(percentVal);
        },
        complete: function(xhr) {
            var response = jQuery.parseJSON(xhr.responseText);
            if(response.error==0)
            {
                
                window.parent.$('#admin_logo_preview').attr("src",base_url+response.name);
                window.parent.$('#admin_logo').attr("value",response.name);
            }
            else
            {
                var error = '<div class="alert alert-danger">'+response.error+'</div>';
                window.parent.$('#admin-upload-error').html(error);
            }

            var percentVal = '0%';
            bar.width(percentVal)
            percent.html(percentVal);
            progress.hide();
            
        }
    });


})(jQuery);