<div class="container main-container">

    <div class="blog-one">
        <div class="row">

            <div class="col-md-8 col-sm-12 col-xs-12 content-panel pt-0 pb-0 pr-0">
                <div class="all-news-content p-4">
                <h2 class="page-title">
                    <?php if(isset($icon) && $icon!=''){?>
                    <i class="fa <?php echo $icon;?>"></i>&nbsp;
                    <?php }?>
                    <?php echo (isset($title))?$title:'';?> <span>&nbsp;</span>
                    <?php 
                    $feed_url = '';
                    if(isset($category_id) && $category_id!='')
                        $feed_url = site_url('show/feed/category/'.$category_id);
                    if(isset($source_id) && $source_id!='')
                        $feed_url = site_url('show/feed/source/'.$source_id);
                    if(isset($publish_time) && $publish_time!='')
                        $feed_url = site_url('show/feed/date/'.$publish_time);

                    ?>
                    <a href="<?php echo $feed_url;?>"><i class="fa fa-rss"></i></a>
                </h2>        
                <hr/>
                <?php
                if($posts->num_rows()<=0){
                    ?>
                    <div class="alert alert-warning"><?php echo lang_key('post_not_found'); ?></div>
                <?php
                }
                else
                    foreach($posts->result() as $news){
                        $news_url = post_detail_url($news); 
                        $title = $news->title;
                        $desc = $news->description;
                        ?>

                        <div class="blog-one-item row">
                            <div class="blog-one-img col-md-3 col-sm-3 col-xs-12">
                                <a href="<?php echo $news_url;?>"><img src="<?php echo $news->media;?>" alt="" class="img-responsive" /></a>
                            </div>

                            <div class="blog-one-content  col-md-9 col-sm-9 col-xs-12">
                                <h3><a href="<?php echo $news_url;?>"><?php echo $title;?></a></h3>
                                <div class="blog-meta">
                                    <i class="fa fa-chain"></i> &nbsp; <a href="<?php echo source_news_url($news->source_id,get_source_title_by_id($news->source_id));?>"><?php echo get_source_title_by_id($news->source_id); ?></a> &nbsp;
                                    <i class="fa fa-calendar"></i> &nbsp; <a href="<?php echo date_news_url($news->publish_time);?>"><?php echo translateable_date($news->publish_time); ?></a>

                                </div>
                                <p><?php echo truncate(strip_tags($desc),100,'&nbsp;<a href="'.$news_url.'">...'.lang_key('view_more').'</a>',false);?></p>
                            </div>
                        </div>
                    <?php } ?>
                <?php render_widgets('all_news_page');?>    
                <ul class="pagination">
                    <?php echo (isset($pages))?$pages:'';?>
                </ul>

                </div>
            </div>


            <div class="col-md-4 col-sm-12 col-xs-12 sidebar-container">
                <div class="sidebar">
                    <?php render_widgets('right_bar_all_news');?>
                </div>
            </div>

        </div>
    </div>

</div> 