<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Classified admin Controller
 *
 * This class handles user account related functionality
 *
 * @package		Show
 * @subpackage	ShowCore
 * @author		webhelios
 * @link		http://webhelios.com
 */

class Grab_model_core extends CI_model {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('admin/content_model');
		$this->load->model('admin/news_model');
		ini_set('max_execution_time', 300);
	}

	public function init()
	{
		$this->load->helper('date');
		$datestring = "%H%i%s";
		$time = time();
		$query = $this->db->get_where('sources',array('status'=>1,'auto_grabbing'=>1));
		$info = "";
		$flag = 0;
		foreach($query->result() as $source)
		{
			$schedules = $this->get_cron_execution_times($source);
			$time = date('H:00:00', time());
			$current_time = strtotime($time);
			if(in_array($current_time, $schedules))
			{
				$flag = 1;
				$this->grabsingle($source->id,'cron');
				$info .= $source->source_name." ".date('Y-m-d h:i:a', time())."\n"; 
			}
		}
		if($flag==0)
		{
			$info = "No source found to execute ".date('Y-m-d h:i:a', time())."\n";
		}

		$this->load->helper('file');
		if ( ! write_file('./assets/logs/cron_log.txt', $info,"a+"))
		{
		     #echo 'Unable to write the file';
		}
		else
		{
		     #echo 'File written!';
		}
		#updated on version 1.4
        $info = (empty($_SERVER['REMOTE_ADDR']))?'cli':'browser';
        if($info=='cli' || (!isset($_SERVER['SERVER_SOFTWARE']) && (php_sapi_name() == 'cli' || (is_numeric($_SERVER['argc']) && $_SERVER['argc'] > 0))))
		{
			echo 'Cron executed';
			die;
		}
		#end
	}
	// removed on version 1.3
	/*
	public function get_cron_execution_times($source)
	{
		$schedule_time = array();
		$schedule_time[0] = strtotime($source->start_on);
		$schedule_time[1] = $schedule_time[0] + $source->grab_duration*60*60;
		$schedule_time[2] = $schedule_time[1] + $source->grab_duration*60*60;
		$schedule_time[3] = $schedule_time[2] + $source->grab_duration*60*60;
		return $schedule_time;
	}
	end */
	// added on version 1.3
    public function get_cron_execution_times($source)
    { 		
        $schedule_time = array();

    	$diff = (isset($source->grab_duration))?$source->grab_duration:2;
    	$j = 0;
        for($i=0;$i<24;$i+=$diff)
        {
        	if($j==0)
	        $schedule_time[0] = strtotime($source->start_on);
	        else
	        $schedule_time[$j] = $schedule_time[$j-1] + $source->grab_duration*60*60;

        	$j++;
        }

        return $schedule_time;
    }
    //end
	public function grabsingle($source_id='',$action='cron')
	{
		$source = $this->content_model->get_source_data_by_id($source_id);
		$this->load->library('rssparser');                          // load library

		if(isset($source->grab_full_news) && $source->grab_full_news==1)
		{
			$this->load->library('feedparser');                          // load library
			$this->feedparser->init();

			$api_url = get_settings('global_settings','five_filters_api_url','http://ftr.fivefilters.org/makefulltextfeed.php');
			// updated on version 1.4
			if(strripos($api_url,'?')>0)
			$five_url = $api_url.'&url='.urlencode($source->rss_url).'&max='.$source->item_per_grab;
			else
			$five_url = $api_url.'?url='.urlencode($source->rss_url).'&max='.$source->item_per_grab;
			//end


			if(strripos($api_url,'ftr-premium.fivefilters.org')>0)
			{
			    $five_url = $source->rss_url;
			}

			// @$this->feedparser->parse($five_url);
			// @$channels  	= $this->feedparser->getChannels();     
			// @$rss     	= $this->feedparser->getItems(); 
			// //$this->rssparser->set_feed_url($five_url);  			// get feed
			
			$this->rssparser->set_feed_url($five_url);  			// get feed
			//$this->rssparser->set_cache_life(30);                       // Set cache life time in minutes
			$rss = $this->rssparser->getFeed($source->item_per_grab);
			
		}
		else
		{			
			$this->rssparser->set_feed_url($source->rss_url);  			// get feed
			//$this->rssparser->set_cache_life(30);                       // Set cache life time in minutes
			$rss = $this->rssparser->getFeed($source->item_per_grab);
		}

		$category_img = get_category_image($source->parent_category);

		foreach ($rss as $item) 
		{

			// echo '<pre>';
			// print_r($item);
			// die;

			$media_url = (isset($item['media']))?$item['media']:'';
			if($media_url=='')
				$media_url = (isset($item['og:image']))?$item['og:image']:'';
			if($media_url!='')
			{
				$is_media_exists = checkRemoteFile($media_url);
				if($is_media_exists)
				{
					if(get_settings('global_settings','save_images_locally','No')=='Yes')
					{
						$url = image_from_url($media_url);
						$image_url = $url;
					}
					else
						$image_url = $media_url;
				}
				else
				{
					// updated on version 1.3
					$image_url 			= $this->get_first_img_source($item['description']);
					if($image_url=='' && !empty($item['encoded']))
					$image_url = $this->get_first_img_source($item['encoded']);
					if(!empty($image_url))
					{
						$is_media_exists = checkRemoteFile($image_url);
						if($is_media_exists)
						{
							if(get_settings('global_settings','save_images_locally','No')=='Yes')
							{
								$url = image_from_url($image_url);
								$image_url = $url;
							}
						}
						else
						{
							$image_url 			= $category_img;
						}					
					}
					else
					{
						$image_url 			= $category_img;					
					}
					//end
				}
			}
			else
			{
				// updated on version 1.3
				$image_url = $this->get_first_img_source($item['description']);
				if($image_url=='' && !empty($item['encoded']))
				$image_url = $this->get_first_img_source($item['encoded']);
				if(!empty($image_url))
				{
					$is_media_exists = checkRemoteFile($image_url);
					if($is_media_exists)
					{
						if(get_settings('global_settings','save_images_locally','No')=='Yes')
						{
							$url = image_from_url($image_url);
							$image_url = $url;
						}
					}
					else
					{
						$image_url 			= $category_img;
					}					
				}
				else
				{
					$image_url 			= $category_img;					
				}
				//end
			}

			$pattern = "This entry passed through the Full-Text RSS service - if this is your content and you're reading it on someone else's site, please read the FAQ at fivefilters.org/content-only/faq.php#publishers.";
			$item['description'] = str_replace($pattern, '', $item['description']);
			$description = $item['description'];
			$description = get_excerpt($description); 
			$data = array();
			$data['source_id'] 			= $source_id;
			$data['category'] 			= $source->parent_category;
			$data['sub_category'] 		= $source->sub_category;
			$data['title'] 				= str_replace("#8217;","’", $item['title']);
			$data['description'] 		= $description;
			$data['full_description'] 	= $item['description'];
			$data['link'] 				= $item['link'];
			$data['media'] 				= $image_url;
			$data['publish_time'] 		= strtotime(isset($item['pubDate'])?$item['pubDate']:$item['pubdate']);
			$data['author'] 			= (isset($item['author']))?$item['author']:'';
			$data['search_meta'] 		= $item['title'].' '.$item['description'];
			$result = $this->news_model->check_if_unique_news(array('title'=>$item['title']));

			$this->load->config('webhelios');
			$blocked_words = $this->config->item('blocked_words');
			if(!empty($blocked_words))
			{
				$blocked_words_array = explode(",", $blocked_words);
				if(0 < count(array_intersect(array_map('strtolower', explode(' ', $data['title']." ".$data['full_description'])), $blocked_words_array)))
					continue;
			}
			$match_words = $this->config->item('match_words');
			if(!empty($match_words))
			{
				$match_words_array = explode(",", $match_words);
				if(0 >= count(array_intersect(array_map('strtolower', explode(' ', $data['title']." ".$data['full_description'])), $match_words_array)))
					continue;
			}
			if($result<=0)
			{
				$data['grab_time'] 		= time();
				$data['grab_action'] 	= 'manual';
				$data['status'] 		= 1;

				$this->news_model->insert_news($data);
			}
		}
		$data = array();
		$data['last_grab_time'] = time();
		$this->db->update('sources',$data,array('id'=>$source_id));
		if($action!='cron')
		{
			$this->session->set_flashdata('msg','<div class="alert alert-success">'.lang_key('news_grabbed').'</div>');
			redirect(site_url('admin/content/allsources'));
		}
	}
	// added on version 1.3
	function get_first_img_source($html)
	{
		preg_match_all('/<img[^>]+>/i',$html, $result); 
		foreach( $result as $img_tag)
		{
		    preg_match_all('/(alt|title|src)=("[^"]*")/i',$img_tag[0], $imges);
		}
		return (isset($imges[2][0]))?str_replace('"', "", $imges[2][0]):'';
	}
	// end
}
/* End of file install.php */
/* Location: ./application/modules/show/controllers/show_core.php */