<?php echo ($this->session->flashdata('msg'));?>
<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i><?php echo lang_key('widget_positions');?></h3>
                <div class="box-tool">
                    <a href="javascript:void(0);" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <form action="<?php echo site_url('admin/widgets/widgetpositions')?>" id="position-form" method="post">
                    <div class="form-group row"  inline-class="admin_inline_247">
                        <div class="col-sm-4 col-lg-5 controls" inline-class="admin_inline_247">
                            <label><?php echo lang_key('widget_positions');?>:</label>
                            <select name="position" id="position" class="form-control form-control-sm">
                                <?php foreach($positions as $position){?>
                                    <?php $sel=($selected_pos==$position->name)?'selected="selected"':'';?>
                                    <option value="<?php echo html_escape($position->name);?>" <?php echo html_escape($sel);?>><?php echo convert_widget_text($position->name);?></option>
                                <?php }?>
                            </select>
                            

                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <a href="" class="show-widget-positions"><?php echo lang_key('explain_widget_position');?></a>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i><?php echo lang_key('available_widgets');?></h3>
                <div class="box-tool">
                    <a href="javascript:void(0);" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <?php
                $active_widgets_array = array();
                if(!empty($active_widgets)){
                    foreach ($active_widgets as $widget) {
                        $active_widgets_array[$widget] = 1;
                    }
                }
                ?>
                <ol id="sortable1" class="droptrue row">
                    <?php foreach($widgets->result() as $row){?>
                        <?php if(isset($active_widgets_array[$row->alias])==FALSE){?>
                            <li class="col-md-3 thumbnail" inline-class="admin_inline_249">
                                <input type="hidden" name="widget[]" value="<?php echo html_escape($row->alias);?>">
                                <div inline-class="admin_inline_250"><?php echo format_long_text($row->name,20);?></div>
                                <a href="<?php echo site_url('admin/widgets/edit/'.$row->alias);?>" inline-class="admin_inline_251" class="edit-widget btn btn-info btn-sm"><?php echo lang_key('edit');?></a>
                            </li>
                        <?php }?>
                    <?php }?>
                </ol>
                <div class="clearfix"></div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="fa fa-bars"></i><?php echo lang_key('active_widgets');?></h3>
                <div class="box-tool">
                    <a href="javascript:void(0);" data-action="collapse"><i class="fa fa-chevron-up"></i></a>

                </div>
            </div>
            <div class="box-content">
                <form action="<?php echo site_url('admin/widgets/savewidgetpositions');?>" id="positions_widgets_form" method="post">
                    <input type="hidden" name="position" value="<?php echo html_escape($selected_pos);?>">
                    <h5><?php echo lang_key('active_widget_position');?> : <?php echo convert_widget_text($selected_pos);?></h5>
                    <?php
                    $CI = get_instance();
                    $CI->load->model('widget_model');
                    ?>
                    <ol id="sortable2" class="droptrue active-widgets row">
                        <?php 
                        if(!empty($active_widgets))
                        {
                            foreach ($active_widgets as $widget) 
                            {
                                $row = $CI->widget_model->get_widget_by_alias($widget);
                                if(is_array($row) && count($row)<=0)
                                {
                                    echo 'widget not found';
                                }
                                else
                                {
                                    ?>
                                    <li class="col-md-3 thumbnail" inline-class="admin_inline_249">
                                        <input type="hidden" name="widget[]" value="<?php echo html_escape($widget);?>">
                                        <div inline-class="admin_inline_253"><?php echo format_long_text($row->name,20);?></div>
                                        <a href="<?php echo site_url('admin/widgets/edit/'.$widget);?>" inline-class="admin_inline_251" class="edit-widget btn btn-info btn-sm"><?php echo lang_key('edit');?></a>
                                    </li>
                                <?php
                                }
                            }
                        }
                        ?>
                    </ol>
                    <div class="clearfix"></div>                    
                    <input type="submit" value="Save" class="btn btn-sm btn-success" inline-class="admin_inline_255"/>
                </form>
                <div class="clearfix"></div>
                
            </div>
        </div>
    </div>
</div>



<div id="position-instruction" class="modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" inline-class="admin_inline_256">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <h4 class="modal-title" id="myModalLabel"><?php echo lang_key('widget_positions'); ?> </h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>


            </div>

            <div class="modal-body">
                <img src="<?php echo base_url('assets/admin/img/position-one.png');?>" inline-class="admin_inline_257" />
            </div>

            <div class="modal-footer">

            </div>

        </div>

        <!-- /.modal-content -->

    </div>

    <!-- /.modal-dialog -->

</div>

<!-- Modal -->
<div class="modal" id="editWidgetModal" inline-class="admin_inline_256" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>