<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Classified System Controller
 *
 * This class handles System management related functionality
 *
 * @package     Admin
 * @subpackage  System
 * @author      webhelios
 * @link        http://webhelios.com
 */

class Sitemap_model extends CI_Model {
    
    public function __construct()
    {
        parent::__construct();
    }
    

    function generate()
    {
        $pages_checked       = 1;
        $categories_checked  = 1;
        $sources_checked     = 1;

        $news_checked        = 1;

        $xml_array=array();


        if($pages_checked==1)
        {

            $menu = get_option('top_menu');
            $menu=json_decode($menu->values);
            $page_url_array=array();
            foreach($menu as $row)
            {
                $id                 = $row->id;
                $url                = $this->get_page_url_by_id($id);
                $page_url_array[]   = $url;
            }
            if($page_url_array)
            {
                $xml_array = $page_url_array;
            }
        }


        if($categories_checked==1){
            $estate_array = array();
            $this->load->model('show/show_model');

            $estate_data = $this->show_model->get_all_categories();

            if($estate_data->num_rows()>0)
            {
                foreach($estate_data->result() as $row)
                {
                    $id = $row->id;
                    $title = $row->title;
                    $url = category_news_url($id,$title);
                    $category_array[]=$url;
                }
            }

            if($category_array){
                $xml_array = array_merge($xml_array,$category_array);
            }
        }

        if($sources_checked==1){
            $source_array = array();
            $this->load->model('admin/content_model');
            $sources = $this->content_model->get_all_sources();

            if($sources->num_rows()>0)
            {
                foreach($sources->result() as $row)
                {
                    $id = $row->id;
                    $title = $row->source_name;
                    $url = source_news_url($id,$title);
                    $source_array[]=$url;
                }
            }

            if($source_array){
                $xml_array = array_merge($xml_array,$source_array);
            }
        }


        $xml = $this->prepare_xml($xml_array);

        $this->load->helper('file');
        if ( ! write_file('./sitemap/sitemap-1.xml',$xml))
        {
            echo 'ROOT/sitemap/sitemap-1.xml does not have write permission'."\n";
        }



        if($news_checked == 1){
            $totalNews =  $this->countAllNews();
            $perPage = 1000;

            $fileCount = 2;

            for($i=0;$i<(int)ceil($totalNews/$perPage);$i++)
            {
                $start =  $i*$perPage;
                $all_post_news = $this->getAllNews($start,$perPage);
                $all_news_array = array();
                foreach($all_post_news->result() as $row){
                    $url        = post_detail_url($row);
                    $all_news_array[] = $url;
                }
    
                $xml = $this->prepare_xml($all_news_array);

                $this->load->helper('file');
                if ( ! write_file('./sitemap/sitemap-'.$fileCount.'.xml',$xml))
                {
                    echo 'ROOT/sitemap/sitemap-'.$fileCount.'.xml does not have write permission'."\n";
                }
                $fileCount++;
            }

        }

        $sitemap_index = '<?xml version="1.0" encoding="UTF-8"?>'."\n".
                         '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'."\n";
    
        $fileCount--;
        
        for($fileCount;$fileCount>=1;$fileCount--)
        {
            $sitemap_index .= '<sitemap>'."\n";
            $sitemap_index .= '<loc>'.base_url('sitemap/sitemap-'.$fileCount.'.xml').'</loc>'."\n";
            $sitemap_index .= '</sitemap>'."\n";
        }

        $sitemap_index .= '</sitemapindex>';

        if ( ! write_file('./sitemap_index.xml',$sitemap_index))
        {
            echo 'ROOT/sitemap_index.xml does not have write permission'."\n";
        }

        echo 'finished';

       

    }

    function getAllNews($start,$limit)
    {
        $this->load->database();
        $this->db->select('*');
        $this->db->where('STATUS',1);
        $this->db->order_by('publish_time', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('news');
        return $query;
    }


    function countAllNews()
    {
        $this->load->database();
        $this->db->select('count(*) as TOTAL');
        $this->db->where('STATUS',1);
        $query = $this->db->get('news');
        return $query->row()->TOTAL;
    }

    // updated on version 1.3
    function prepare_xml($xml_array='')
    {
        $xml = '';
        if(isset($xml_array) && is_array($xml_array))
        {
            $xml = '<?xml version="1.0" encoding="UTF-8" ?>'."\n".
                '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'."\n".
                     '<url>'."\n".
                         '<loc>'.base_url().'</loc>'."\n".
                            '<priority>0.9</priority>'."\n".
                            '<changefreq>always</changefreq>'."\n".
                        '</url>'."\n";

            foreach($xml_array as $url)
            {
                $xml .= '<url>'."\n".
                            '<loc>'.$url.'</loc>'."\n".
                            '<priority>0.9</priority>'."\n".
                            '<changefreq>always</changefreq>'."\n".
                        '</url>'."\n";
            }
            $xml .= "</urlset>"."\n";
        }
        return $xml;
    }
    //end

    function get_page_url_by_id($id='')
    {
        $this->load->model('admin/page_model_core');
        $page = $this->page_model_core->get_page_by_id($id);

        if($page->content_from=='Url')
        {
            $url = site_url($page->url);
        }
        else
        {
            $url = site_url('page/'.$page->alias);
        }
        return $url;
    }


}

/* End of file system.php */
/* Location: ./application/modules/admin/controllers/admin/system.php */