<?php
//file updated on version 1.4
$CI = get_instance();
$CI->load->model('admin/news_model');
$news_query = $CI->news_model->get_news_by_source_category_subcategory($source_id,$category,$sub_category,$limit);

?>
<div class="widget-content-body">
	<div class="block-heading-two">
	    <div class="body-widget-title"><span><i class="fa fa-folder"></i> <?php echo $wid_title;?></span>
		    <div class="view-all-category-top">
		    	<a href="<?php echo $more_url;?>"><?php echo lang_key('view_all');?></a>
		    </div>
	    </div>
	</div>
	<div class="row p-2">
		<?php 
		if($news_query->num_rows()<=0)
		{
		?>
		<div class="col-lg-12">
			<div class="alert alert-info"><?php echo lang_key('no_news_found');?></div>
		</div>
		<?php
		}
		else
		{
			$news_array = $news_query->result_array();

			$main_news = $news_array[0];
			$main_news_url = post_detail_url($main_news);
			$main_news_source = get_source_title_by_id($main_news['source_id']);

			#added on version 1.4
		    $main_news_source_url 	= source_news_url($main_news['source_id'],$main_news_source);
		    $main_news_date_url 		= date_news_url($main_news['publish_time']);

			unset($news_array[0]);
		?>
		<div class="col-md-6 col-sm-6 col-xs-12 main-news">
			<article>
						
					<a class="image-link" title="<?php echo $main_news['title'];?>" href="<?php echo $main_news_url;?>">
						<div class="page-body-widget-main-img">
						<?php if($CI->session->userdata('lazyload')=='yes'){?>
						<img title="<?php echo $main_news['title'];?>" alt="<?php echo $main_news['title'];?>" class="lazy img-responsive main-news-image" data-src="<?php echo resolve_mixed_url($main_news['media']);?>" src="<?php echo base_url('assets/images/no-image.jpeg');?>">						
						<?php }else{?>
						<img title="<?php echo $main_news['title'];?>" alt="<?php echo $main_news['title'];?>" class="img-responsive main-news-image" src="<?php echo resolve_mixed_url($main_news['media']);?>">						
						<?php }?>
						</div>
					</a>
					
					<div class="main-news-meta">

						<span class="news-by">
							<span class="news-by-body">
							 <a href="<?php echo $main_news_source_url;?>"><?php echo $main_news_source;#added on version 1.4?></a>
							</span>
						</span>

						<span class="news-by">
							<span class="news-by-body">						
								<a href="<?php echo $main_news_date_url;?>"><?php echo translateable_date($main_news['publish_time']);#added on version 1.4?></a>
							</span>	
						</span>
															
						<span class="news-by comments">
							<span class="news-by-title">
								<?php echo lang_key('seen_by');?>: 
							</span>
							
							<span class="news-by-body">						
								<a href="<?php echo $main_news_url;?>"><i class="fa fa-eye"></i><?php echo $main_news['total_view'];?></a>
							</span>
						</span>					
					</div>
					
					<h2 class="main-news-title"><a title="<?php echo $main_news['title'];?>" href="<?php echo $main_news_url;?>"><?php echo $main_news['title'];?></a></h2>
					
					<div class="excerpt">
						<p>
						<?php echo truncate(strip_tags($main_news['description']),100,'&nbsp;<a href="'.$main_news_url.'">...'.lang_key('view_more').'</a>',false);?>
						</p>
					</div>
					
			</article>
		</div>
		<div class="col-md-6 col-sm-6 col-xs-12 news-lists v-separator">
			<div class="s-widget">
				<div class="widget-content hot-properties">
				<ul class="list-unstyled body-list-news">
					<?php 
					foreach ($news_array as $news)
					{
						$news_url = post_detail_url($news);
						$news_source = get_source_title_by_id($news['source_id']);
						$source_url 	= source_news_url($news['source_id'],$news_source);
					    $date_url 		= date_news_url($news['publish_time']);
					?>
		            <li class="col-xs-12 col-sm-12 col-md-12 col-lg-12 list-news">
		                
		                <a href="<?php echo $news_url;?>">
		                	<?php if($CI->session->userdata('lazyload')=='yes'){?>
		                	<img alt="<?php echo $news['title'];?>" data-src="<?php echo $news['media'];?>" src="<?php echo base_url('assets/images/no-image.jpeg');?>" class="lazy-thumb img-responsive">
		                	<?php }else{?>
		                	<img alt="<?php echo $news['title'];?>" src="<?php echo $news['media'];?>" class="img-responsive">
		                	<?php }?>
		                </a>
		                <div class="sub-head"><a href="<?php echo $news_url;?>">
		                	<?php echo format_long_text($news['title'],75);?>
		                </a></div>
		                <!-- Price -->
		                <div class="price">
							<span class="news-by">
								<span class="news-by-body">
									<a href="<?php echo $date_url;?>"><?php echo translateable_date($news['publish_time'])?></a> -
								</span>
							</span>
		                	<span class="news-by">
								<span class="news-by-body">
									<a href="<?php echo $source_url;?>"><?php echo $news_source;?></a>
								</span>
							</span>
		                </div>
		                <div class="clearfix"></div>
		            </li>
		            <?php
			        }
		            ?>          	            	            
	            </ul>
		        </div>            
		    </div>
		</div>
	<?php 
		}
	?>	
	</div>
</div>
<hr class="separator">